﻿using VA.TMP.Integration.VIMT.VideoVisit.Mappers;
using VA.TMP.Integration.VIMT.VideoVisit.StateObject;
using VRM.Integration.Servicebus.Core;

namespace VA.TMP.Integration.VIMT.VideoVisit.PipelineSteps.Create
{
    /// <summary>
    /// Create Appointment step.
    /// </summary>
    public class MapAppointmentStep : FilterBase<VideoVisitCreateStateObject>
    {
        /// <summary>
        /// Execute the step.
        /// </summary>
        /// <param name="state">State object.</param>
        public override void Execute(VideoVisitCreateStateObject state)
        {
            var isGroup = state.ServiceAppointment.mcs_groupappointment ?? false;
            var videoVisitMapper = new VideoVisitMapper(state.OrganizationServiceProxy, state.ServiceAppointment, state.ContactIds, state.SystemUsers, isGroup, state.CrmAppointment);
            state.Appointment = videoVisitMapper.Map();
        }
    }
}